* This file analyzes the Japanese data

use "Japan/Japan2.dta", clear
replace dt=round(dt,.01)

* Renumber questions: Only 4 important series breaks
replace q=3 if q==2
replace q=5 if q==4
for X in num 1 3 5 6 \ Y in num 1/4: replace q=Y if q==X

* Get GDP data
gen str3 cty="JPN"
append using "Processed files\Complete_GDP" , keep(year cty gdp)
keep if cty=="JPN"

*** Fig 19, top
* Get a graph of the economic data
gen lgdp=ln(gdp)
gen str4 gdprate=""
for X in num 1/4 \ Y in num 1958 1964 1970 1992 \ Z in num 1963 1969 1991 2007: reg lgdp year if year>=Y & year<=Z \ predict gdpX if year>=Y & year<=Z \ replace gdpX=exp(gdpX) \ replace gdprate=string(round(_b[year]*100,.1))+"%" if year==Z
drop lgdp
#delimit ;
twoway
	(line gdp year if year>1957)
	(connected gdp1 year if year>1957, sort msymbol(none) lcolor(gray) lpattern(dash) mlabel(gdprate) mlabcolor(gray) mlabpos(9))
	(connected gdp2 year if year>1957, sort msymbol(none) lcolor(gray) lpattern(dash) mlabel(gdprate) mlabcolor(gray) mlabpos(9))
	(connected gdp3 year if year>1957, sort msymbol(none) lcolor(gray) lpattern(dash) mlabel(gdprate) mlabcolor(gray) mlabpos(9))
	(connected gdp4 year if year>1957, sort msymbol(none) lcolor(gray) lpattern(dash) mlabel(gdprate) mlabcolor(gray) mlabpos(12))
	(line ue dt, sort yaxis(2) lpattern(longdash) lcolor(cranberry))
,
	ti("Income and unemployment")
	xtitle("")
	xlabel(1960(10)2010)
	yscale(log)
	ylabel(500 "0.5" 1000 "1" 2000 "2" 4000 "4" 8000 "8" 16000 "16" 32000 "32", angle(horizontal))
	ytitle("Real GDP per capita" "(thousands of dollars, PPP, log scale)")
	ylabel(0(1)6, axis(2) angle(horizontal) format(%9.0f))
	ytitle("Unemployment rate, percent", axis(2))
	legend(off)
	text(17000 1968 "Real GDP per capita" "(left axis)", color(green))
	text(5000 1988 "Unemployment rate" "(right axis)", color(cranberry))
	xsize(10) ysize(7.5)
	name(jap_ec, replace)
;
#delimit cr


*** Fig 19, bottom
* Deal with macro data
replace dt=year+.5 if dt==.
gen lgdp_ann=ln(gdp)
ipolate lgdp_ann dt, gen(lgdp) epolate 
drop lgdp_ann
replace gdp=exp(lgdp)
ipolate ue dt, gen(unr)
drop ue

* Clean up dataset
keep if sat4~=.
sort dt
list dt qn viable sat1 sat2 sat3 sat4 gdp unr, clean

* Create ordered probit indices
gen n=viableresponses
reshape long sat, i(dt) j(s)
rename sat wt
rename s sat
gen fw=round(wt*n,1)

xi: oprobit sat i.dt [fw=fw], cluster(dt)
predict sath if sat~=., xb
summ sath
replace sath=sath-r(mean)
la var sath "Simple ordered probit, not accounting for series breaks"
gen sat_hat=.
levelsof qn, local(qns)
foreach q of local qns {
	xi: oprobit sat i.dt [fw=fw] if qn==`q'
	predict sat_hat_`q' if sat~=. & qn==`q', xb
	summ dt if qn==`q' & sat~=.
	local mind=r(min)
	summ sat_hat_`q' if abs(dt-`mind')<.01
	replace sat_hat_`q'=sat_hat_`q'-r(mean)
	replace sat_hat=sat_hat_`q' if qn==`q'
}

keep if sat==1
drop sat wt

xi: reg sat_hat lgdp unr i.qn
summ unr
gen sat_hat_adj=sat_hat-_b[_Iqn_2]*_Iqn_2-_b[_Iqn_3]*_Iqn_3-_b[_Iqn_4]*_Iqn_4
gen sat_hat_unr=sat_hat_adj-_b[unr]*(unr-r(mean))
xi: reg sat_hat lgdp i.qn

set seed 69
gen u=uniform()
gen x=.
for X in num 1963.5 1969.5 1991.83 \ Y in num 1/3: gen xY=X 
gen y=-.25+.5*(u>.5)

#delimit ;
twoway
	(connected sat_hat dt if qn==1, sort yaxis(1) lpattern(dash) lcolor(green) msymbol(square) lcolor(green) mcolor(green)  msize(vsmall) lwidth(vvthin) )
	(connected sat_hat dt if qn==2, sort lpattern(dash) lcolor(navy) msymbol(circle) lcolor(navy) mcolor(navy) msize(vsmall) lwidth(vvthin))
	(connected sat_hat dt if qn==3, sort lpattern(dash) lcolor(cranberry) msymbol(triangle) lcolor(cranberry) mcolor(cranberry) msize(vsmall) lwidth(vvthin) )
	(connected sat_hat dt if qn==4, sort lpattern(dash) lcolor(brown) msymbol(diamond) lcolor(brown) mcolor(brown) msize(vsmall) lwidth(vvthin))
	(line y x1, sort lpattern(dot) lwidth(vvthin) lcolor(black))
	(line y x2, sort lpattern(dot) lwidth(vvthin) lcolor(black))
	(line y x3, sort lpattern(dot) lwidth(vvthin) lcolor(black))
	(line sat_hat_adj dt, sort lcolor(gray) lpattern(solid))
	(line sat_hat_unr dt, sort lcolor(black) lwidth(medthick) lpattern(solid) yaxis(1 2))
,
	ti("Life satisfaction")
	xtitle("")
	xlabel(1960(10)2010)
	ytitle("Ordered probit index", axis(2))
	ylabel(-.5(.25).75, angle(horizontal) axis(2) format(%4.2f))
	ytick(-.5(.25).75, axis(2) notick)
	ylabel(0 "      ", axis(1) angle(horizontal) notick)
	legend(off)
	text(-.15 1982 "Raw series," "with breaks")
	text(.7 2004 "Adjusted for" "series breaks" "& unemployment")
	text(.25 2003 "Adjusted for" "series breaks")
	xsize(10) ysize(7.5)
	name(jap_hap, replace)
;
#delimit cr

#delimit ;
graph combine jap_ec jap_hap,
	imargin(small)
	rows(2)
	xsize(7.5) ysize(10)
	name(fig19, replace)
;
#delimit cr
graph save "Figures/fig19", replace


*** Figure 18
gen str30 yr=string(year)

for X in num 1/4: summ dt if sat_hat_X ~=. \ reg sat_hat_X lgdp \ reg sat_hat_X dt \ reg lgdp dt if sat_hat_X~=.
for X in num 1/4: reg sat_hat_X lgdp \ predict sat_fit_X if sat_hat_X~=.  \ global bX=string(round(_b[lgdp],.001),"%4.2f") \ global seX=string(round(_se[lgdp],.001),"%4.2f")
#delimit ;
twoway
	(scatter sat_hat_1 gdp, msymbol(square) mlabel(yr) mcolor(green) mlabcolor(green) mlabpos(12) mlabsize(vsmall))
	(line sat_fit_1 gdp, sort lpattern(dash) lcolor(green))
	(scatter sat_hat_2 gdp, msymbol(circle) mlabel(yr) mcolor(navy) mlabcolor(navy) mlabpos(12) mlabsize(vsmall))
	(line sat_fit_2 gdp, sort lpattern(dash) lcolor(navy))
	(scatter sat_hat_3 gdp, msymbol(triangle) mlabel(yr) mcolor(cranberry) mlabcolor(cranberry) mlabpos(12) mlabsize(vsmall))
	(line sat_fit_3 gdp, sort lpattern(dash) lcolor(cranberry))
	(scatter sat_hat_4 gdp, msymbol(diamond) mlabel(yr) mcolor(brown) mlabcolor(brown) mlabpos(12) mlabsize(vsmall))
	(line sat_fit_4 gdp, sort lpattern(dash) lcolor(brown))
,
	xtitle("Real GDP per capita (thousands of dollars, PPP, log scale)", size(small))
	xscale(log)
	xlabel(2000 4000 8000 16000 32000)
	ytitle("Life satisfaction (ordered probit index)", size(small))
	ylabel(-.3(.1).3, angle(horizontal) format(%9.1f))
	ytick(.45, notick)
	xline(3700 7600 24000, lcolor(black))
	text(.46 1920 "Q1. How do you feel about" "your circumstances at home:" "-Satisfied" "-Not satisfied, not dissatisfied" "-Somewhat dissatisfied" "-Extremely dissatisfied", size(vsmall) justification(left) placement(5))
	text(.46 4000 "Q2. How do you feel about" "your life at home:" "-Completely satisfied" "-Satisfied" "-Somewhat dissatisfied" "-Completely dissatisfied", size(vsmall) justification(left) placement(5))
	text(.46 8000 "Q3. How do you feel about" "your life now:" "-Completely satisfied" "-Satisfied" "-Somewhat dissatisfied" "-Completely dissatisfied", size(vsmall) justification(left) placement(5))
	text(.46 24500 "Q4. Overall," "to what" "degree are you" "satisfied with" "your life now:" "-Satisfied" "-Somewhat" " satisfied" "-Somewhat" " dissatisfied" "-Dissatisfied", size(vsmall) justification(left) placement(5))
	text(-.35 1920 "Slope=$b1" "[se=$se1]",size(vsmall) justification(left) placement(3))
	text(-.35 4000 "Slope=$b2" "[se=$se2]",size(vsmall) justification(left) placement(3))
	text(-.35 8000 "Slope=$b3" "[se=$se3]",size(vsmall) justification(left) placement(3))
	text(-.35 24500 "Slope=$b4" "[se=$se4]",size(vsmall) justification(left) placement(3))
	legend(off)
	xsize(10) ysize(7.5)
	name(fig18, replace)
;
#delimit cr
graph save "Figures/fig18.gph", replace


